#include "scripts.h"
#include "engine.h"
#include <time.h>
#include "jfw2.h"
void JFW_Bounce_Zone_Entry::Entered(GameObject * obj,GameObject * enter)
{
	int x;
	float amount;
	Vector3 pos;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,x) != 0)
	{
		return;
	}
	amount = Get_Float_Parameter("Amount");
	pos = Commands->Get_Position(enter);
	pos.Z += amount;
	Commands->Set_Position(enter,pos);
}
void JFW_Grant_Key_Zone_Entry::Entered(GameObject * obj,GameObject * enter)
{
	int x;
	int key;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,x) != 0)
	{
		return;
	}
	key = Get_Int_Parameter("Key");
	Commands->Grant_Key(enter,key,true);
}
void JFW_Custom_Play_Cinematic::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	const char *scriptname;
	Vector3 position;
	GameObject * object;
	float facing;
	msg = Get_Int_Parameter("Message");
	scriptname = Get_Parameter("Script_Name");
	position = Get_Vector3_Parameter("Location");
	facing = Get_Float_Parameter("Facing");
	if (message == msg)
	{
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
	}
}
void JFW_Debug_Text_File::Created(GameObject * obj)
{
	int id;
	t = time(0);
	filename = Get_Parameter("Log_File");
	description = Get_Parameter("Description");
	f = fopen(filename,"wt");
	id = Commands->Get_ID(obj);
	fprintf(f,"%s [ID %d] created.\n",description,id);
	fflush(f);
}
void JFW_Debug_Text_File::Destroyed(GameObject * obj)
{
	int id;
	id = Commands->Get_ID(obj);
	fprintf(f,"%s [ID %d] shutdown.\n",description,id);
	fflush(f);
	fclose(f);
}
void JFW_Debug_Text_File::Killed(GameObject * obj,GameObject * shooter)
{
	float timediff;
	int id,id2;
	t2 = time(0);
	timediff = (float)difftime(t2,t);
	id = Commands->Get_ID(obj);
	id2 = Commands->Get_ID(shooter);
	fprintf(f,"%s [ID %d] killed by object %d. %f sec.\n",description,id,id2,timediff);
	fflush(f);
}
void JFW_Debug_Text_File::Damaged(GameObject * obj,GameObject * damager,float damage)
{
	float timediff;
	int id,id2;
	t2 = time(0);
	timediff = (float)difftime(t2,t);
	id = Commands->Get_ID(obj);
	id2 = Commands->Get_ID(damager);
	fprintf(f,"%s [ID %d] damaged by object %d. Damage was %f %f sec.\n",description,id,id2,damage,timediff);
	fflush(f);
}
void JFW_Debug_Text_File::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	float timediff;
	int id,id2;
	t2 = time(0);
	timediff = (float)difftime(t2,t);
	id = Commands->Get_ID(obj);
	id2 = Commands->Get_ID(sender);
	fprintf(f,"%s [ID %d] received custom event of type %d and param %d. Sender was object %d. %f sec.\n",description,id,message,param,id2,timediff);
	fflush(f);
}
void JFW_Debug_Text_File::Sound_Heard(GameObject * obj,const CombatSound & sound)
{
	float timediff;
	int id;
	t2 = time(0);
	timediff = (float)difftime(t2,t);
	id = Commands->Get_ID(obj);
	fprintf(f,"%s [ID %d] heard sound %d at position %f %f %f object %d. %f sec.\n",description,id,sound.sound,sound.position.X,sound.position.Y,sound.position.Z,Commands->Get_ID(sound.obj),timediff);
	fflush(f);
}
void JFW_Debug_Text_File::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	float timediff;
	int id,id2;
	t2 = time(0);
	timediff = (float)difftime(t2,t);
	id = Commands->Get_ID(obj);
	id2 = Commands->Get_ID(seen);
	fprintf(f,"%s [ID %d] saw enemy: object %d. %f sec.\n",description,id,id2,timediff);
	fflush(f);
}
void JFW_Debug_Text_File::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	float timediff;
	int id;
	const char *reasonstr;
	t2 = time(0);
	timediff = (float)difftime(t2,t);
	id = Commands->Get_ID(obj);
	switch (reason)
	{
	case ACTION_COMPLETE_ATTACK_OUT_OF_RANGE:
		reasonstr = "ACTION_COMPLETE_ATTACK_OUT_OF_RANGE";
		break;
	case ACTION_COMPLETE_MOVE_NO_PROGRESS_MADE:
		reasonstr = "ACTION_COMPLETE_MOVE_NO_PROGRESS_MADE";
		break;
	case ACTION_COMPLETE_PATH_BAD_DEST:
		reasonstr = "ACTION_COMPLETE_PATH_BAD_DEST";
		break;
	case ACTION_COMPLETE_PATH_BAD_START:
		reasonstr = "ACTION_COMPLETE_PATH_BAD_START";
		break;
	case ACTION_COMPLETE_LOW_PRIORITY:
		reasonstr = "ACTION_COMPLETE_LOW_PRIORITY";
		break;
	case ACTION_COMPLETE_NORMAL:
		reasonstr = "ACTION_COMPLETE_NORMAL";
		break;
	default:
		reasonstr = "ACTION_COMPLETE_NORMAL";
	}
	fprintf(f,"Action %d complete on %s [ID %d] -- Reason: %s. %f sec.\n",action,description,id,reasonstr);
	fflush(f);
}
void JFW_Debug_Text_File::Timer_Expired(GameObject * obj,int number)
{
	float timediff;
	int id;
	t2 = time(0);
	timediff = (float)difftime(t2,t);
	id = Commands->Get_ID(obj);
	fprintf(f,"timer %d on %s [ID %d] expired. %f sec.\n",number,description,id,timediff);
	fflush(f);
}
void JFW_Debug_Text_File::Animation_Complete(GameObject * obj,const char *anim)
{
	float timediff;
	int id;
	t2 = time(0);
	timediff = (float)difftime(t2,t);
	id = Commands->Get_ID(obj);
	fprintf(f,"animation %s on %s [ID %d] complete. %f sec.\n",anim,description,id,timediff);
	fflush(f);
}
void JFW_Debug_Text_File::Poked(GameObject * obj,GameObject * poker)
{
	float timediff;
	int id,id2;
	t2 = time(0);
	timediff = (float)difftime(t2,t);
	id = Commands->Get_ID(obj);
	id2 = Commands->Get_ID(poker);
	fprintf(f,"%s [ID %d] was poked by: object %d. %f sec.\n",description,id,id2,timediff);
	fflush(f);
}
void JFW_Debug_Text_File::Entered(GameObject * obj,GameObject * enter)
{
	float timediff;
	int id,id2;
	t2 = time(0);
	timediff = (float)difftime(t2,t);
	id = Commands->Get_ID(obj);
	id2 = Commands->Get_ID(enter);
	fprintf(f,"%s [ID %d] was entered by: object %d. %f sec.\n",description,id,id2,timediff);
	fflush(f);
}
void JFW_Debug_Text_File::Exited(GameObject * obj, GameObject * exit)
{
	float timediff;
	int id,id2;
	t2 = time(0);
	timediff = (float)difftime(t2,t);
	id = Commands->Get_ID(obj);
	id2 = Commands->Get_ID(exit);
	fprintf(f,"%s [ID %d] was exited by: object %d. %f sec.\n",description,id,id2,timediff);
	fflush(f);
}
void JFW_Timer_Custom::Created(GameObject * obj)
{
	float timertime;
	int timernumber;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
}
void JFW_Timer_Custom::Timer_Expired(GameObject * obj,int number)
{
	int timernumber;
	int repeat;
	float timertime;
	GameObject * object;
	int ID,msg,param;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	repeat = Get_Int_Parameter("Repeat");
	ID = Get_Int_Parameter("ID");
	msg = Get_Int_Parameter("Message");
	param = Get_Int_Parameter("Param");
	object = Commands->Find_Object(ID);
	if (number == timernumber)
	{
		Commands->Send_Custom_Event(obj,object,msg,param,0);
		if (repeat == 1)
		{	
			Commands->Start_Timer(obj,this,timertime,timernumber);
		}
	}
}
void JFW_Blow_Up_On_Death::Killed(GameObject * obj,GameObject * shooter)
{
	Vector3 v;
	const char *c;
	c = Get_Parameter("Explosion");
	v = Commands->Get_Position(obj);
	Commands->Create_Explosion (c, v, 0);
}
void JFW_Zone_Send_Custom_Enable::Entered(GameObject * obj,GameObject * enter)
{
	GameObject * object;
	int message;
	int ID;
	int param;
	int pltype;
	pltype = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,pltype) != 0)
	{
		return;
	}
	ID = Get_Int_Parameter("ID");
	message = Get_Int_Parameter("EnterMessage");
	param = Get_Int_Parameter("EnterParam");
	object = Commands->Find_Object(ID);
	if (enabled == true)
	{
		if (message != 0)
		{
			if (param == 0)
			{
				param = Commands->Get_ID(enter);
			}
			Commands->Send_Custom_Event(obj,object,message,param,0);
		}
	}
}
void JFW_Zone_Send_Custom_Enable::Exited(GameObject * obj, GameObject * exit)
{
	GameObject * object;
	int message;
	int ID;
	int param;
	int pltype;
	pltype = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(exit,pltype) != 0)
	{
		return;
	}
	ID = Get_Int_Parameter("ID");
	message = Get_Int_Parameter("ExitMessage");
	param = Get_Int_Parameter("ExitParam");
	object = Commands->Find_Object(ID);
	if (enabled == true)
	{
		if (message != 0)
		{
			if (param == 0)
			{
				param = Commands->Get_ID(exit);
			}
			Commands->Send_Custom_Event(obj,object,message,param,0);
		}
	}
}
void JFW_Zone_Send_Custom_Preset::Entered(GameObject * obj,GameObject * enter)
{
	GameObject * object;
	int message;
	int ID;
	int param;
	const char *preset;
	const char *c;
	int pltype;
	pltype = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,pltype) != 0)
	{
		return;
	}
	ID = Get_Int_Parameter("ID");
	message = Get_Int_Parameter("EnterMessage");
	param = Get_Int_Parameter("EnterParam");
	object = Commands->Find_Object(ID);
	c = Get_Parameter("Preset_Name");
	preset = Commands->Get_Preset_Name(enter);
	if (strcmp(preset,c) == 0)
	{
		if (message != 0)
		{
			if (param == 0)
			{
				param = Commands->Get_ID(enter);
			}
			Commands->Send_Custom_Event(obj,object,message,param,0);
		}
	}
}
void JFW_Zone_Send_Custom_Preset::Exited(GameObject * obj, GameObject * exit)
{
	GameObject * object;
	int message;
	int ID;
	int param;
	const char *preset;
	const char *c;
	int pltype;
	pltype = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(exit,pltype) != 0)
	{
		return;
	}
	ID = Get_Int_Parameter("ID");
	message = Get_Int_Parameter("ExitMessage");
	param = Get_Int_Parameter("ExitParam");
	object = Commands->Find_Object(ID);
	c = Get_Parameter("Preset_Name");
	preset = Commands->Get_Preset_Name(exit);
	if (strcmp(preset,c) == 0)
	{
		if (message != 0)
		{
			if (param == 0)
			{
				param = Commands->Get_ID(exit);
			}
			Commands->Send_Custom_Event(obj,object,message,param,0);
		}
	}
}
void JFW_Zone_Send_Custom_Enable::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg,msg2;
	msg = Get_Int_Parameter("Enable_Message");
	msg2 = Get_Int_Parameter("Disable_Message");
	if (msg == message)
	{
		enabled = true;
	}
	if (msg2 == message)
	{
		enabled = false;
	}
}
void JFW_Zone_Send_Custom_Enable::Created(GameObject * obj)
{
	enabled = false;
}
void JFW_Zone_Send_Custom_Enable::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
}
void JFW_Zone_Send_Custom_Enable_Enter::Entered(GameObject * obj,GameObject * enter)
{
	GameObject * object;
	int message;
	int param;
	int pltype;
	pltype = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,pltype) != 0)
	{
		return;
	}
	message = Get_Int_Parameter("EnterMessage");
	param = Get_Int_Parameter("EnterParam");
	object = enter;
	if (enabled == true)
	{
		Commands->Send_Custom_Event(obj,object,message,param,0);
	}
}
void JFW_Zone_Send_Custom_Enable_Enter::Exited(GameObject * obj, GameObject * exit)
{
	GameObject * object;
	int message;
	int param;
	int pltype;
	pltype = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(exit,pltype) != 0)
	{
		return;
	}
	message = Get_Int_Parameter("ExitMessage");
	param = Get_Int_Parameter("ExitParam");
	object = exit;
	if (enabled == true)
	{
		Commands->Send_Custom_Event(obj,object,message,param,0);
	}
}
void JFW_Zone_Send_Custom_Preset_Enter::Entered(GameObject * obj,GameObject * enter)
{
	GameObject * object;
	int message;
	int param;
	const char *preset;
	const char *c;
	int pltype;
	pltype = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,pltype) != 0)
	{
		return;
	}
	message = Get_Int_Parameter("EnterMessage");
	param = Get_Int_Parameter("EnterParam");
	object = enter;
	c = Get_Parameter("Preset_Name");
	preset = Commands->Get_Preset_Name(enter);
	if (strcmp(preset,c) == 0)
	{
		Commands->Send_Custom_Event(obj,object,message,param,0);
	}
}
void JFW_Zone_Send_Custom_Preset_Enter::Exited(GameObject * obj, GameObject * exit)
{
	GameObject * object;
	int message;
	int param;
	const char *preset;
	const char *c;
	int pltype;
	pltype = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(exit,pltype) != 0)
	{
		return;
	}
	message = Get_Int_Parameter("ExitMessage");
	param = Get_Int_Parameter("ExitParam");
	object = exit;
	c = Get_Parameter("Preset_Name");
	preset = Commands->Get_Preset_Name(exit);
	if (strcmp(preset,c) == 0)
	{
		Commands->Send_Custom_Event(obj,object,message,param,0);
	}
}
void JFW_Zone_Send_Custom_Enable_Enter::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg,msg2;
	msg = Get_Int_Parameter("Enable_Message");
	msg2 = Get_Int_Parameter("Disable_Message");
	if (msg == message)
	{
		enabled = true;
	}
	if (msg2 == message)
	{
		enabled = false;
	}
}
void JFW_Zone_Send_Custom_Enable_Enter::Created(GameObject * obj)
{
	enabled = false;
}
void JFW_Zone_Send_Custom_Enable_Enter::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
}
void JFW_2D_Sound_Timer_Random::Created(GameObject * obj)
{
	float timertime,timemin,timemax;
	int timernumber;
	timemin = Get_Float_Parameter("Time_Min");
	timemax = Get_Float_Parameter("Time_Max");
	timernumber = Get_Int_Parameter("TimerNum");
	timertime = Commands->Get_Random(timemin,timemax);
	Commands->Start_Timer(obj,this,timertime,timernumber);
}
void JFW_2D_Sound_Timer_Random::Timer_Expired(GameObject * obj,int number)
{
	float timertime,timemin,timemax;
	int timernumber;
	int repeat;
	const char *c;
	timemin = Get_Float_Parameter("Time_Min");
	timemax = Get_Float_Parameter("Time_Max");
	timernumber = Get_Int_Parameter("TimerNum");
	repeat = Get_Int_Parameter("Repeat");
	c = Get_Parameter("Sound");
	if (number == timernumber)
	{
		Commands->Create_2D_Sound(c);
		if (repeat == 1)
		{	
			timertime = Commands->Get_Random(timemin,timemax);
			Commands->Start_Timer(obj,this,timertime,timernumber);
		}
	}
}
void JFW_3D_Sound_Timer_Random::Created(GameObject * obj)
{
	float timertime,timemin,timemax;
	int timernumber;
	timemin = Get_Float_Parameter("Time_Min");
	timemax = Get_Float_Parameter("Time_Max");
	timernumber = Get_Int_Parameter("TimerNum");
	timertime = Commands->Get_Random(timemin,timemax);
	Commands->Start_Timer(obj,this,timertime,timernumber);
}
void JFW_3D_Sound_Timer_Random::Timer_Expired(GameObject * obj,int number)
{
	float timertime,timemin,timemax;
	int timernumber;
	int repeat;
	Vector3 v;
	const char* c;
	timemin = Get_Float_Parameter("Time_Min");
	timemax = Get_Float_Parameter("Time_Max");
	timernumber = Get_Int_Parameter("TimerNum");
	repeat = Get_Int_Parameter("Repeat");
	v = Get_Vector3_Parameter("Position");
	c = Get_Parameter("Sound");
	if (number == timernumber)
	{
		Commands->Create_Sound(c,v,obj);
		if (repeat == 1)
		{	
			timertime = Commands->Get_Random(timemin,timemax);
			Commands->Start_Timer(obj,this,timertime,timernumber);
		}
	}
}
void JFW_2D_Sound_Timer_Health::Created(GameObject * obj)
{
	float timertime;
	int timernumber;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
}
void JFW_2D_Sound_Timer_Health::Timer_Expired(GameObject * obj,int number)
{
	int timernumber;
	float minhealth,maxhealth,health;
	float timertime;
	int repeat;
	const char *c;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	repeat = Get_Int_Parameter("Repeat");
	minhealth = Get_Float_Parameter("Min_Health");
	maxhealth = Get_Float_Parameter("Max_Health");
	c = Get_Parameter("Sound");
	if (number == timernumber)
	{
		health = Commands->Get_Health(obj);
		if ((health >= minhealth) && (health <= maxhealth))
		{
			Commands->Create_2D_Sound(c);
		}
		if (repeat == 1)
		{	
			Commands->Start_Timer(obj,this,timertime,timernumber);
		}
	}
}
void JFW_Aircraft_Fuel::Created(GameObject * obj)
{
	entered = false;
}
void JFW_Aircraft_Fuel::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	float timertime;
	int timernumber;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	msg = Get_Int_Parameter("Refuel_Message");
	if (msg == message)
	{
		Commands->Start_Timer(obj,this,timertime,timernumber);
	}
	if ((message == CUSTOM_EVENT_VEHICLE_ENTER) && (entered == false))
	{
		Commands->Start_Timer(obj,this,timertime,timernumber);
		entered = true;
	}
}
void JFW_Aircraft_Fuel::Timer_Expired(GameObject * obj,int number)
{
	int timernumber;
	const char *c;
	Vector3 v;
	timernumber = Get_Int_Parameter("TimerNum");
	c = Get_Parameter("Explosion");
	v = Commands->Get_Position(obj);
	if (number == timernumber)
	{
		Commands->Create_Explosion(c,v,0);
	}
}
void JFW_Aircraft_Fuel::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&entered);
}
void JFW_Power_Off::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg,msg2;
	msg = Get_Int_Parameter("Message_Off");
	msg2 = Get_Int_Parameter("Message_On");
	if (msg == message)
	{
		Commands->Set_Building_Power(obj,false);
	}
	if (msg2 == message)
	{
		Commands->Set_Building_Power(obj,true);
	}
}
void JFW_Assault_Powerplant_Controller::Created(GameObject * obj)
{
	float timertime;
	int timernumber;
	int poweroff;
	int building;
	GameObject * object;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	poweroff = Get_Int_Parameter("Power_Off");
	Commands->Start_Timer(obj,this,timertime,timernumber);
	building = Get_Int_Parameter("Building1");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building2");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building3");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building4");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building5");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building6");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building7");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building8");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building9");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building10");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building11");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building12");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building13");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building14");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building15");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	inzone = false;
}
void JFW_Assault_Powerplant_Controller::Timer_Expired(GameObject * obj,int number)
{
	int timernumber;
	int poweroff;
	int building;
	GameObject * object;
	timernumber = Get_Int_Parameter("TimerNum");
	poweroff = Get_Int_Parameter("Power_Off");
	if ((inzone == false) && (number == timernumber))
	{
		building = Get_Int_Parameter("Building1");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building2");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building3");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building4");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building5");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building6");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building7");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building8");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building9");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building10");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building11");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building12");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building13");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building14");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building15");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	}
}
void JFW_Assault_Powerplant_Controller::Entered(GameObject * obj,GameObject * enter)
{
	int x;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,x) != 0)
	{
		return;
	}
	inzone = true;
}
void JFW_Assault_Powerplant_Controller::Exited(GameObject * obj, GameObject * exit)
{
	int x;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(exit,x) != 0)
	{
		return;
	}
	inzone = false;
}
void JFW_Assault_Powerplant_Controller::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&inzone);
}
void JFW_Nod_Obelisk_CnC::Created(GameObject * obj)
{
	Vector3 v;
	GameObject * object;
	v = Commands->Get_Position(obj);
	v.Z += 45;
	int x;
	int controllerid;
	object = Commands->Create_Object("Nod_Obelisk",v);
	if (object != 0)
	{
		Commands->Attach_Script(object,"JFW_Obelisk_Weapon_CnC","0");
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		x = Commands->Get_ID(object);
		controllerid = Get_Int_Parameter("Controller_ID");
		object = Commands->Find_Object(controllerid);
		Commands->Send_Custom_Event(obj,object,9033,x,0);
	}
}
void JFW_Nod_Obelisk_CnC::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,3,0,0);
	}
}
void JFW_Nod_Obelisk_CnC::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	GameObject * object;
	if ((message == 1) && (message == param))
	{
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			Commands->Destroy_Object(object);
		}
	}
}
void JFW_Nod_Obelisk_CnC::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,1,0,0);
			}
			else
			{
				Commands->Send_Custom_Event(obj,object,1,1,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Nod_Obelisk_CnC::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Obelisk_Weapon_CnC::Created(GameObject * obj)
{
	Vector3 v;
	GameObject * object;
	attack = false;
	range = 150.0f;
	effectid = 0;
	attackid = 0;
	EnemySeen = true;
	Commands->Set_Player_Type(obj,0);
	Commands->Set_Is_Rendered(obj,false);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	v = Commands->Get_Position(obj);
	object = Commands->Create_Object("Obelisk Effect",v);
	if (object != 0)
	{
		effectid = Commands->Get_ID(object);
		Commands->Set_Animation_Frame(object,"OBL_POWERUP.OBL_POWERUP", 0);
	}
}
void JFW_Obelisk_Weapon_CnC::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	Vector3 pos,pos2;
	float distance;
	GameObject * object;
	switch(message)
	{
	case 1:
	if (param == 0)
	{
		Commands->Enable_Enemy_Seen(obj,false);
		EnemySeen = false;
		ActionParamsStruct params;
		params.Set_Basic(this,100,0,-1);
		params.Set_Attack(obj,0,0,true);
		Commands->Action_Attack(obj,params);
		Commands->Action_Reset(obj,100);
		if (effectid != 0)
		{
			object = Commands->Find_Object(effectid);
			if (object != 0)
			{
				Commands->Set_Animation_Frame(object,"OBL_POWERUP.OBL_POWERUP", 0);
			}
		}
	}
	else
	{
		Commands->Enable_Enemy_Seen(obj,true);
		EnemySeen = true;
	}
	break;
	case 2:
		if (!attack && EnemySeen)
		{
			object = Commands->Find_Object(param);
			if (object != 0)
			{
				pos = Commands->Get_Position(obj);
				pos2 = Commands->Get_Position(object);
				distance = Commands->Get_Distance(pos,pos2);
				pos.Z = 0;
				pos2.Z = 0;
				if ((Commands->Get_Distance(pos,pos2) > 15) && (range >= distance))
				{
					attackid = param;
					EnemySeen = false;
					Commands->Start_Timer(obj,this,2.0,1);
					object = Commands->Find_Object(effectid);
					if (object != 0)
					{
						Commands->Set_Animation_Frame(object,"OBL_POWERUP.OBL_POWERUP", 1);
					}
					pos2.Z -= 20;
					Commands->Create_Sound("Obelisk_Warm_Up",pos2,obj);
				}
				else
				{
					if (effectid != 0)
					{
						object = Commands->Find_Object(effectid);
						if (object != 0)
						{
							Commands->Set_Animation_Frame(object,"OBL_POWERUP.OBL_POWERUP", 0);
						}
					}
					Commands->Action_Reset(obj,100);
				}
			}
		}
	break;
	case 3:
		attack = true;
		if (effectid != 0)
		{
			object = Commands->Find_Object(effectid);
			if (object != 0)
			{
				Commands->Set_Animation_Frame(object,"OBL_POWERUP.OBL_POWERUP", 0);
			}
		}
	break;
	}
}
void JFW_Obelisk_Weapon_CnC::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	int id;
	if (attack == 0)
	{
		id = Commands->Get_ID(seen);
		Commands->Send_Custom_Event(obj,obj,2,id,0);
	}
}
void JFW_Obelisk_Weapon_CnC::Timer_Expired(GameObject * obj,int number)
{
	GameObject * object;
	Vector3 pos,pos2;
	float distance;
	if (attack == 0)
	{
		if (number == 1)
		{
			object = Commands->Find_Object(attackid);
			if (object != 0)
			{
				pos = Commands->Get_Position(obj);
				pos2 = Commands->Get_Position(object);
				distance = Commands->Get_Distance(pos,pos2);
				pos.Z = 0;
				pos2.Z = 0;
				if ((Commands->Get_Distance(pos,pos2) > 15) && (range >= distance))
				{
					ActionParamsStruct params;
					params.Set_Basic(this,100,0,-1);
					params.Set_Attack(object,range,0,true);
					Commands->Action_Attack(obj,params);
					attackid = 0;
					Commands->Start_Timer(obj,this,2.0,2);
				}
				else
				{
					if (effectid != 0)
					{
						object = Commands->Find_Object(effectid);
						if (object != 0)
						{
							Commands->Set_Animation_Frame(object,"OBL_POWERUP.OBL_POWERUP", 0);
						}
					}
					Commands->Action_Reset(obj,100);
					EnemySeen = true;
				}
			}
			else
			{
				if (effectid != 0)
				{
					object = Commands->Find_Object(effectid);
					if (object != 0)
					{
						Commands->Set_Animation_Frame(object,"OBL_POWERUP.OBL_POWERUP", 0);
					}
				}
				Commands->Action_Reset(obj,100);
				EnemySeen = true;
			}
		}
		else
		{
			if (number == 2)
			{
				if (effectid != 0)
				{
					object = Commands->Find_Object(effectid);
					if (object != 0)
					{
						Commands->Set_Animation_Frame(object,"OBL_POWERUP.OBL_POWERUP", 0);
					}
				}
				EnemySeen = true;
			}
		}
	}
}
void JFW_Obelisk_Weapon_CnC::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&EnemySeen);
	Auto_Save_Variable(2,4,&attackid);
	Auto_Save_Variable(3,4,&effectid);
	Auto_Save_Variable(4,4,&range);
	Auto_Save_Variable(5,1,&attack);
}
void JFW_Advanced_Guard_Tower::Created(GameObject * obj)
{
	Vector3 v,missilepos,gun1pos,gun2pos,gun3pos,gun4pos;
	GameObject * object;
	enable = true;
	Commands->Enable_Hibernation(obj,false);
	missileid = 0;
	gun1id = 0;
	gun2id = 0;
	gun3id = 0;
	gun4id = 0;
	v = Commands->Get_Position(obj);
	missilepos.X = v.X;
	missilepos.Y = v.Y;
	missilepos.Z = v.Z + 6.0f;
	gun1pos.X = v.X + 5.1789999f;
	gun1pos.Y = v.Y - 4.2389998f;
	gun1pos.Z = v.Z - 9.0f;
	gun2pos.X = v.X + 5.1609998f;
	gun2pos.Y = v.Y + 3.2720001f;
	gun2pos.Z = v.Z - 9.0f;
	gun3pos.X = v.X - 4.4910002f;
	gun3pos.Y = v.Y + 3.257f;
	gun3pos.Z = v.Z - 9.0f;
	gun4pos.X = v.X - 5.1329999f;
	gun4pos.Y = v.Y - 4.3660002f;
	gun4pos.Z = v.Z - 9.0f;
	object = Commands->Create_Object("GDI_AGT",missilepos);
	if (object != 0)
	{
		Commands->Attach_Script(object,"JFW_Advanced_Guard_Tower_Missile","0");
		missileid = Commands->Get_ID(object);
	}
	object = Commands->Create_Object("GDI_Ceiling_Gun_AGT",gun1pos);
	if (object != 0)
	{
		Commands->Attach_Script(object,"JFW_Advanced_Guard_Tower_Gun","0");
		gun1id = Commands->Get_ID(object);
	}
	object = Commands->Create_Object("GDI_Ceiling_Gun_AGT",gun2pos);
	if (object != 0)
	{
		Commands->Attach_Script(object,"JFW_Advanced_Guard_Tower_Gun","0");
		gun2id = Commands->Get_ID(object);
	}
	object = Commands->Create_Object("GDI_Ceiling_Gun_AGT",gun3pos);
	if (object != 0)
	{
		Commands->Attach_Script(object,"JFW_Advanced_Guard_Tower_Gun","0");
		gun3id = Commands->Get_ID(object);
	}
	object = Commands->Create_Object("GDI_Ceiling_Gun_AGT",gun4pos);
	if (object != 0)
	{
		Commands->Attach_Script(object,"JFW_Advanced_Guard_Tower_Gun","0");
		gun4id = Commands->Get_ID(object);
	}
	Commands->Start_Timer(obj,this,1.0,1);
	Commands->Start_Timer(obj,this,1.0,2);
}
void JFW_Advanced_Guard_Tower::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject *gun1obj,*gun2obj,*gun3obj,*gun4obj;
	gun1obj = Commands->Find_Object(gun1id);
	gun2obj = Commands->Find_Object(gun2id);
	gun3obj = Commands->Find_Object(gun3id);
	gun4obj = Commands->Find_Object(gun4id);
	if (gun1obj != 0)
	{
		Commands->Send_Custom_Event(obj,gun1obj,3,0,0);
	}
	if (gun2obj != 0)
	{
		Commands->Send_Custom_Event(obj,gun2obj,3,0,0);
	}
	if (gun3obj != 0)
	{
		Commands->Send_Custom_Event(obj,gun3obj,3,0,0);
	}
	if (gun4obj != 0)
	{
		Commands->Send_Custom_Event(obj,gun4obj,3,0,0);
	}
}
void JFW_Advanced_Guard_Tower::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	GameObject *gun1obj,*gun2obj,*gun3obj,*gun4obj;
	gun1obj = Commands->Find_Object(gun1id);
	gun2obj = Commands->Find_Object(gun2id);
	gun3obj = Commands->Find_Object(gun3id);
	gun4obj = Commands->Find_Object(gun4id);
	switch (message)
	{
	case 0:
		enable = false;
		if (gun1obj != 0)
		{
			Commands->Send_Custom_Event(obj,gun1obj,2,0,0);
		}
		if (gun2obj != 0)
		{
			Commands->Send_Custom_Event(obj,gun2obj,2,0,0);
		}
		if (gun3obj != 0)
		{
			Commands->Send_Custom_Event(obj,gun3obj,2,0,0);
		}
		if (gun4obj != 0)
		{
			Commands->Send_Custom_Event(obj,gun4obj,2,0,0);
		}
		break;
	case 1:
		enable = true;
		if (gun1obj != 0)
		{
			Commands->Send_Custom_Event(obj,gun1obj,2,1,0);
		}
		if (gun2obj != 0)
		{
			Commands->Send_Custom_Event(obj,gun2obj,2,1,0);
		}
		if (gun3obj != 0)
		{
			Commands->Send_Custom_Event(obj,gun3obj,2,1,0);
		}
		if (gun4obj != 0)
		{
			Commands->Send_Custom_Event(obj,gun4obj,2,1,0);
		}
		break;
	}
}
void JFW_Advanced_Guard_Tower::Timer_Expired(GameObject * obj,int number)
{
	GameObject *gun1obj,*gun2obj,*gun3obj,*gun4obj;
	gun1obj = Commands->Find_Object(gun1id);
	gun2obj = Commands->Find_Object(gun2id);
	gun3obj = Commands->Find_Object(gun3id);
	gun4obj = Commands->Find_Object(gun4id);
	switch (number)
	{
	case 1:
		if (gun1obj != 0)
		{
			Commands->Send_Custom_Event(obj,gun1obj,1,missileid,0);
		}
		if (gun2obj != 0)
		{
			Commands->Send_Custom_Event(obj,gun2obj,1,missileid,0);
		}
		if (gun3obj != 0)
		{
			Commands->Send_Custom_Event(obj,gun3obj,1,missileid,0);
		}
		if (gun4obj != 0)
		{
			Commands->Send_Custom_Event(obj,gun4obj,1,missileid,0);
		}
		break;
	case 2:
		if ((Commands->Get_Building_Power(obj) == true) && (Commands->Get_Health(obj) != 0))
		{
			if (enable == true)
			{
				if (gun1obj != 0)
				{
					Commands->Send_Custom_Event(obj,gun1obj,2,1,0);
				}
				if (gun2obj != 0)
				{
					Commands->Send_Custom_Event(obj,gun2obj,2,1,0);
				}
				if (gun3obj != 0)
				{
					Commands->Send_Custom_Event(obj,gun3obj,2,1,0);
				}
				if (gun4obj != 0)
				{
					Commands->Send_Custom_Event(obj,gun4obj,2,1,0);
				}
			}
			Commands->Start_Timer(obj,this,1.0,2);
		}
		else
		{
			if (gun1obj != 0)
			{
				Commands->Send_Custom_Event(obj,gun1obj,2,0,0);
			}
			if (gun2obj != 0)
			{
				Commands->Send_Custom_Event(obj,gun2obj,2,0,0);
			}
			if (gun3obj != 0)
			{
				Commands->Send_Custom_Event(obj,gun3obj,2,0,0);
			}
			if (gun4obj != 0)
			{
				Commands->Send_Custom_Event(obj,gun4obj,2,0,0);
			}
			Commands->Start_Timer(obj,this,1.0,2);
		}
		break;
	}
}
void JFW_Advanced_Guard_Tower::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&missileid);
	Auto_Save_Variable(2,4,&gun1id);
	Auto_Save_Variable(3,4,&gun2id);
	Auto_Save_Variable(4,4,&gun3id);
	Auto_Save_Variable(5,4,&gun4id);
	Auto_Save_Variable(6,1,&enable);
}
void JFW_Advanced_Guard_Tower_Missile::Created(GameObject * obj)
{
	Commands->Set_Is_Rendered(obj,false);
	Commands->Enable_Hibernation(obj,false);
	enable = false;
}
void JFW_Advanced_Guard_Tower_Missile::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	GameObject * object;
	Vector3 pos,pos2;
	if (message == 1)
	{
		object = Commands->Find_Object(param);
		if (object != 0)
		{
			pos = Commands->Get_Position(obj);
			pos2 = Commands->Get_Position(object);
			if ((Commands->Get_Distance(pos,pos2) > 30) && (enable == false))
			{
				enable = true;
				ActionParamsStruct params;
				params.Set_Basic(this,100,1,-1);
				params.Set_Attack_Hold(object,300,0,true,false);
				Commands->Action_Attack(obj,params);
				Commands->Start_Timer(obj,this,1.0,1);
			}
		}
	}
}
void JFW_Advanced_Guard_Tower_Missile::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_Advanced_Guard_Tower_Missile::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enable);
}
void JFW_Advanced_Guard_Tower_Gun::Created(GameObject * obj)
{
	Commands->Set_Shield_Type(obj,"Blamo");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	id = 0;
	enable = false;
}
void JFW_Advanced_Guard_Tower_Gun::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	switch (message)
	{
	case 1:
		id = param;
	break;
	case 2:
		if (param == false)
		{
			Commands->Enable_Enemy_Seen(obj,false);
		}
		else
		{
			Commands->Enable_Enemy_Seen(obj,true);
		}
	break;
	case 3:
		enable = true;
		Commands->Action_Reset(obj,100);
	break;
	}
}
void JFW_Advanced_Guard_Tower_Gun::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject * object;
	Vector3 pos,pos2;
	if (enable == true)
	{
		object = Commands->Find_Object(id);
		if (object != 0)
		{
			Commands->Send_Custom_Event(obj,object,1,Commands->Get_ID(seen),0);
		}
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		if (Commands->Get_Distance(pos,pos2) > 20)
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack_Hold(seen,300,0,true,false);
			Commands->Action_Attack(obj,params);
			Commands->Start_Timer(obj,this,1.0,1);
		}
	}
}
void JFW_Advanced_Guard_Tower_Gun::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_Advanced_Guard_Tower_Gun::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&id);
	Auto_Save_Variable(2,1,&enable);
}
void JFW_Building_Gun::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Weapon",params);
	}
}
void JFW_Building_Gun::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
			else
			{
				Commands->Send_Custom_Event(obj,object,x,1,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Weapon::Created(GameObject * obj)
{
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
}
void JFW_Building_Gun_Weapon::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		Commands->Enable_Enemy_Seen(obj,param);
	}
}
void JFW_Building_Gun_Weapon::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	float minrange;
	float maxrange;
	float range;
	minrange = Get_Float_Parameter("Min_Range");
	maxrange = Get_Float_Parameter("Max_Range");
	Vector3 pos,pos2;
	pos = Commands->Get_Position(obj);
	pos2 = Commands->Get_Position(seen);
	range = Commands->Get_Distance(pos,pos2);
	pos.Z = 0;
	pos2.Z = 0;
	if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange))
	{
		ActionParamsStruct params;
		params.Set_Basic(this,100,1,-1);
		params.Set_Attack(seen,maxrange,0,true);
		Commands->Action_Attack(obj,params);
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Weapon::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_Building_Gun_No_Aircraft::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("Preset1"),Get_Parameter("Preset2"),Get_Parameter("Preset3"),Get_Parameter("Preset4"),Get_Parameter("Preset5"),Get_Parameter("Preset6"),Get_Parameter("Preset7"),Get_Parameter("Preset8"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Weapon_No_Aircraft",params);
	}
}
void JFW_Building_Gun_No_Aircraft::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_No_Aircraft::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
			else
			{
				Commands->Send_Custom_Event(obj,object,x,1,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_No_Aircraft::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Weapon_No_Aircraft::Created(GameObject * obj)
{
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
}
void JFW_Building_Gun_Weapon_No_Aircraft::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		if (param == false)
		{
			Commands->Enable_Enemy_Seen(obj,false);
		}
		else
		{
			Commands->Enable_Enemy_Seen(obj,true);
		}
	}
}
void JFW_Building_Gun_Weapon_No_Aircraft::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	float minrange;
	float maxrange;
	float range;
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) != 0))
	{
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange))
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(seen,maxrange,0,true);
			Commands->Action_Attack(obj,params);
			Commands->Start_Timer(obj,this,1.0,1);
		}
	}
}
void JFW_Building_Gun_Weapon_No_Aircraft::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_Building_Gun_Aircraft_Only::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("Preset1"),Get_Parameter("Preset2"),Get_Parameter("Preset3"),Get_Parameter("Preset4"),Get_Parameter("Preset5"),Get_Parameter("Preset6"),Get_Parameter("Preset7"),Get_Parameter("Preset8"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Weapon_Aircraft_Only",params);
	}
}
void JFW_Building_Gun_Aircraft_Only::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_Aircraft_Only::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
			else
			{
				Commands->Send_Custom_Event(obj,object,x,1,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Aircraft_Only::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Weapon_Aircraft_Only::Created(GameObject * obj)
{
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
}
void JFW_Building_Gun_Weapon_Aircraft_Only::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		if (param == false)
		{
			Commands->Enable_Enemy_Seen(obj,false);
		}
		else
		{
			Commands->Enable_Enemy_Seen(obj,true);
		}
	}
}
void JFW_Building_Gun_Weapon_Aircraft_Only::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	float minrange;
	float maxrange;
	float range;
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) == 0))
	{
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange))
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(seen,maxrange,0,true);
			Commands->Action_Attack(obj,params);
			Commands->Start_Timer(obj,this,1.0,1);
		}
	}
}
void JFW_Building_Gun_Weapon_Aircraft_Only::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_Guard_Duty_Helper::Created(GameObject * obj)
{
	Commands->Set_Is_Rendered(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
}
void JFW_Guard_Duty_Helper::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	int id;
	int helpermsg;
	int seenid;
	GameObject * object;
	id = Get_Int_Parameter("ID");
	helpermsg = Get_Int_Parameter("Helper_Msg");
	object = Commands->Find_Object(id);
	seenid = Commands->Get_ID(seen);
	Commands->Send_Custom_Event(obj,object,helpermsg,seenid,0);
}
void JFW_Guard_Duty::Created(GameObject * obj)
{
	const char *helperobj;
	const char *helperbone;
	float range;
	int dummyobj;
	int helpermsg;
	int waypathid;
	char param[100];
	GameObject * object;
	helperobj = Get_Parameter("Helper_Obj");
	helperbone = Get_Parameter("Helper_Bone");
	range = Get_Float_Parameter("Range");
	dummyobj = Get_Int_Parameter("Dummy_Object");
	helpermsg = Get_Int_Parameter("Helper_Msg");
	waypathid = Get_Int_Parameter("Waypathid");
	object = Commands->Create_Object_At_Bone(obj,helperobj,helperbone);
	Commands->Attach_To_Object_Bone(object,obj,helperbone);
	helperid = Commands->Get_ID(obj);
	sprintf(param,"%d,%d",helperid,helpermsg);
	Commands->Attach_Script(object,"JFW_Guard_Duty_Helper",param);
	ActionParamsStruct params;
	object = Commands->Find_Object(dummyobj);
	params.Set_Move_Arrive_Distance(100);
	params.Set_Basic(this,100,777,-1);
	params.Set_Attack(object,range,0.5,true);
	params.Set_Goto_Waypath(waypathid,true,false,false);
	Commands->Action_Attack(obj,params);
}
void JFW_Guard_Duty::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	float range;
	int dummyobj;
	int waypathid;
	GameObject * object;
	range = Get_Float_Parameter("Range");
	dummyobj = Get_Int_Parameter("Dummy_Object");
	waypathid = Get_Int_Parameter("Waypathid");
	ActionParamsStruct params;
	if (action == 777){
		object = Commands->Find_Object(dummyobj);
		params.Set_Move_Arrive_Distance(100);
		params.Set_Basic(this,100,777,-1);
		params.Set_Attack(object,range,0.5,true);
		params.Set_Goto_Waypath(waypathid,true,false,false);
		Commands->Action_Attack(obj,params);
	}
}
void JFW_Guard_Duty::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	float range;
	int helpermsg;
	int waypathid;	
	float attacktime;
	GameObject * object;
	range = Get_Float_Parameter("Range");
	helpermsg = Get_Int_Parameter("Helper_Msg");
	waypathid = Get_Int_Parameter("Waypathid");
	attacktime = Get_Float_Parameter("Attack_Time");
	if (message == helpermsg)
	{
		object = Commands->Find_Object(param);
		ActionParamsStruct params;
		params.Set_Basic(this,100,777,-1);
		params.Set_Move_Arrive_Distance(100);
		params.Set_Goto(0,0.1f,range);
		params.Set_Attack(object,range,0.5,true);
		params.Set_Goto_Waypath(waypathid,true,true,false);
		Commands->Modify_Action(obj,777,params,true,true);
		Commands->Start_Timer(obj,this,attacktime,1);
		object = Commands->Find_Object(helperid);
		Commands->Enable_Enemy_Seen(object,false);
	}
}
void JFW_Guard_Duty::Timer_Expired(GameObject * obj,int number)
{
	int dummyobj;
	float range;
	int waypathid;	
	float waittime;
	ActionParamsStruct params;
	GameObject * object;
	range = Get_Float_Parameter("Range");
	dummyobj = Get_Int_Parameter("Dummy_Object");
	waypathid = Get_Int_Parameter("Waypathid");
	waittime = Get_Float_Parameter("Wait_Time");
	switch (number)
	{
	case 1:
		object = Commands->Find_Object(dummyobj);
		params.Set_Move_Arrive_Distance(100);
		params.Set_Basic(this,100,777,-1);
		params.Set_Attack(object,range,0.5,true);
		params.Set_Goto_Waypath(waypathid,true,false,false);
		Commands->Modify_Action(obj,777,params,true,true);
		Commands->Start_Timer(obj,this,waittime,2);
	break;
	case 2:
		object = Commands->Find_Object(helperid);
		Commands->Enable_Enemy_Seen(object,true);
	break;
	}
}
void JFW_Guard_Duty::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&helperid);
}
void JFW_Hunt_Attack::Created(GameObject * obj)
{
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Enable_Hibernation(obj,false);
}
void JFW_Hunt_Attack::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	float range;
	range = Get_Float_Parameter("Attack_Range");
	ActionParamsStruct params;
	params.Set_Move_Arrive_Distance(100);
	params.Set_Basic(this,100,1,-1);
	params.Set_Attack(seen,range,0,true);
	Commands->Action_Attack(obj,params);
}
void JFW_Hunt_Attack::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}
void JFW_Hunt_Blow_Up::Created(GameObject * obj)
{
	firsttime = true;
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Enable_Hibernation(obj,false);
}
void JFW_Hunt_Blow_Up::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	float speed;
	float distance;
	speed = Get_Float_Parameter("Speed");
	distance = Get_Float_Parameter("Distance");
	ActionParamsStruct params;
	params.Set_Move_Arrive_Distance(100);
	params.Set_Basic(this,100,777,-1);
	params.Set_Goto_Following(seen,speed,distance,true);
	Commands->Action_Goto(obj,params);
}
void JFW_Hunt_Blow_Up::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Vector3 v;
	if ((action == 777) && (firsttime == false))
	{
		Commands->Action_Reset(obj,100);
		v = Commands->Get_Position(obj);
		Commands->Create_Explosion(Get_Parameter("Explosion"),v,0);
	}
	else
	{
		firsttime = false;
	}
}
void JFW_Hunt_Blow_Up::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&firsttime);
}
void JFW_Follow_Waypath::Created(GameObject * obj)
{
	int waypathid;
	float speed;
	waypathid = Get_Int_Parameter("Waypathid");
	speed = Get_Float_Parameter("Speed");
	ActionParamsStruct params;
	params.Set_Move_Arrive_Distance(100);
	params.Set_Basic(this,100,777,-1);
	params.Set_Goto(0,speed,10);
	params.Set_Goto_Waypath(waypathid,true,false,false);
	Commands->Action_Goto(obj,params);
}
void JFW_Give_Money::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	int amount;
	int team;
	msg = Get_Int_Parameter("Message");
	if (msg == message)
	{
		team = Get_Int_Parameter("Entire_Team");
		amount = Get_Int_Parameter("Amount");
		Commands->Give_Money(sender, (float)amount, team);
	}
}
void JFW_2D_Sound_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Message");
	if (message == msg)
	{
		Commands->Create_2D_Sound(Get_Parameter("Preset"));
	}
}

void JFW_Random_Custom::Created(GameObject * obj)
{
	float timertime,timemin,timemax;
	int timernumber;
	timemin = Get_Float_Parameter("Time_Min");
	timemax = Get_Float_Parameter("Time_Max");
	timernumber = Get_Int_Parameter("TimerNum");
	timertime = Commands->Get_Random(timemin,timemax);
	Commands->Start_Timer(obj,this,timertime,timernumber);
}
void JFW_Random_Custom::Timer_Expired(GameObject * obj,int number)
{
	float timertime,timemin,timemax;
	int timernumber;
	int repeat;
	int ID;
	int msg;
	timemin = Get_Float_Parameter("Time_Min");
	timemax = Get_Float_Parameter("Time_Max");
	timernumber = Get_Int_Parameter("TimerNum");
	repeat = Get_Int_Parameter("Repeat");
	if (number == timernumber)
	{
		msg = Get_Int_Parameter("Message");
		ID = Get_Int_Parameter("ID");
		Commands->Send_Custom_Event(obj,Commands->Find_Object(ID),msg,0,0);
		if (repeat == 1)
		{	
			timertime = Commands->Get_Random(timemin,timemax);
			Commands->Start_Timer(obj,this,timertime,timernumber);
		}
	}
}
void JFW_Resource_Collector::Created(GameObject * obj)
{
	cash = 0;
	ID = 0;
}
void JFW_Resource_Collector::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int Collected_Message = Get_Int_Parameter("Collected_Mesasge");
	int Refinery_Message = Get_Int_Parameter("Refinery_Message");
	int Cash_Limit = Get_Int_Parameter("Cash_Limit");
	int Cash_Type = Get_Int_Parameter("Cash_Type");
	int Entire_Team = Get_Int_Parameter("Entire_Team");
	if (message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		int OldID;
		OldID = ID;
		ID = Commands->Get_ID(sender);
		if (Cash_Type == 0)
		{
			cash = 0;
		}
		if ((Cash_Type == 1) && (ID != OldID))
		{
			cash = 0;
		}
	}
	if (message == Collected_Message)
	{
		if (Cash_Type == 3)
		{
			cash = 0;
		}
		cash += param;
		if ((cash > Cash_Limit) && (Cash_Limit != 0))
		{
			cash = Cash_Limit;
		}
	}
	if (message == Refinery_Message)
	{
		Commands->Give_Money(Commands->Find_Object(ID),(float)cash,Entire_Team);
		cash = 0;
	}
}
void JFW_Resource_Collector::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&cash);
	Auto_Save_Variable(1,4,&ID);
}
void JFW_Resource_Refinery::Entered(GameObject * obj,GameObject * enter)
{
	int Refinery_Message = Get_Int_Parameter("Refinery_Message");
	Commands->Send_Custom_Event(obj,enter,Refinery_Message,0,0);
}
void JFW_Resource_Field::Created(GameObject * obj)
{
	ID = 0;
}
void JFW_Resource_Field::Entered(GameObject * obj,GameObject * enter)
{
	const char *Nod_Preset = Get_Parameter("Nod_Preset");
	const char *Preset = Commands->Get_Preset_Name(enter);
	const char *GDI_Preset = Get_Parameter("GDI_Preset");
	if (ID == 0)
	{
		if ((stricmp(Preset,Nod_Preset) == 0) || (stricmp(Preset,GDI_Preset) == 0))
		{
			ID = Commands->Get_ID(enter);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNum"));
			Commands->Send_Custom_Event(obj,enter,Get_Int_Parameter("StartHarvest"),0,0);
		}
	}
}
void JFW_Resource_Field::Exited(GameObject * obj, GameObject * exit)
{
	if (Commands->Get_ID(exit) == ID)
	{
		ID = 0;
		//This line added by NeoSaber:
		Commands->Send_Custom_Event(obj,exit,Get_Int_Parameter("StopHarvest"),0,0);
	}
}
void JFW_Resource_Field::Timer_Expired(GameObject * obj,int number)
{
	int Cash = Get_Int_Parameter("Cash");
	int Collected_Message = Get_Int_Parameter("Collected_Message");
	Vector3 pos;
	float angle;
	GameObject *object;
	const char *Collected_Preset = Get_Parameter("Collected_Preset");
	float Collected_Preset_Distance = Get_Float_Parameter("Collected_Preset_Distance");
	if (ID != 0)
	{
		object = Commands->Find_Object(ID);
		Commands->Send_Custom_Event(obj,object,Collected_Message,Cash,0);
		pos = Commands->Get_Position(object);
		angle = Commands->Get_Facing(object);
		pos.X+=Collected_Preset_Distance*(float)cos(angle);
		pos.Y+=Collected_Preset_Distance*(float)sin(angle);
		Commands->Create_Object(Collected_Preset,pos);
		Commands->Send_Custom_Event(obj,object,Get_Int_Parameter("StopHarvest"),0,0);
	}
}
void JFW_Resource_Field::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&ID);
}
void JFW_Custom_Damage_Object::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg = Get_Int_Parameter("Message");
	if (message == msg)
	{
		int ID = Get_Int_Parameter("ID");
		float damage = Get_Float_Parameter("Damage");
		GameObject *obj = Commands->Find_Object(ID);
		float health = Commands->Get_Health(obj);
		if (damage >= health)
		{
			health = 0;
		}
		else
		{
			health -= damage;
		}
		Commands->Set_Health(obj,health);
		if (health == 0)
		{
			Commands->Destroy_Object(obj);
		}
	}
}

void JFW_Blow_Up_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	const char *c;
	int msg;
	Vector3 v;
	msg = Get_Int_Parameter("Message");
	if (message == msg)
	{
		c = Get_Parameter("Explosion");
		v = Commands->Get_Position(sender);
		Commands->Create_Explosion(c,v,0);
	}
}
void JFW_Blow_Up_Obj_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	const char *c;
	int msg;
	Vector3 v;
	msg = Get_Int_Parameter("Message");
	if (message == msg)
	{
		c = Get_Parameter("Explosion");
		v = Commands->Get_Position(obj);
		Commands->Create_Explosion(c,v,0);
	}
}
void JFW_Delay_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	float delay = Get_Float_Parameter("Delay");
	int msg = Get_Int_Parameter("Message");
	int ID = Get_Int_Parameter("ID");
	if (msg == message)
	{
		Commands->Send_Custom_Event(sender,Commands->Find_Object(ID),message,param,delay);
	}
}
void JFW_Startup_Custom::Created(GameObject * obj)
{
	int msg = Get_Int_Parameter("Message");
	int ID = Get_Int_Parameter("ID");
	Commands->Send_Custom_Event(obj,Commands->Find_Object(ID),msg,0,0);
}
void JFW_Clear_Weapons::Entered(GameObject * obj,GameObject * enter)
{
	Commands->Clear_Weapons(enter);
}
void JFW_Send_Custom_Zone_Enter::Entered(GameObject * obj,GameObject * enter)
{
	if (CheckPlayerType(enter,Get_Int_Parameter("Team_ID")) != 0)
		return;
	GameObject * object = enter;
	Commands->Send_Custom_Event(obj, object, Get_Int_Parameter("EnterMessage"), Get_Int_Parameter("EnterParam"), 0);
}
void JFW_Send_Custom_Zone_Enter::Exited(GameObject * obj, GameObject * exit)
{
	if (CheckPlayerType(exit,Get_Int_Parameter("Team_ID")) != 0)
		return;
	GameObject * object = exit;
	Commands->Send_Custom_Event(obj, object, Get_Int_Parameter("ExitMessage"), Get_Int_Parameter("ExitParam"), 0);
}
void JFW_Gate_Zone::Entered(GameObject * obj,GameObject * enter)
{
	int Player_Type = Get_Int_Parameter("Player_Type");
	int ID = Get_Int_Parameter("ID");
	const char *Animation = Get_Parameter("Animation");
	int TimerNum = Get_Int_Parameter("TimerNum");
	float Time = Get_Float_Parameter("Time");
	if (CheckPlayerType(enter,Player_Type) != 0)
	{
		return;
	}
	Commands->Static_Anim_Phys_Goto_Last_Frame(ID,Animation);
	Commands->Start_Timer(obj,this,Time,TimerNum);
}
void JFW_Gate_Zone::Timer_Expired(GameObject * obj,int number)
{
	int ID = Get_Int_Parameter("ID");
	const char *Animation = Get_Parameter("Animation");
	int TimerNum = Get_Int_Parameter("TimerNum");
	if (TimerNum == number)
	{
		Commands->Static_Anim_Phys_Goto_Frame(ID,0.0,Animation);
	}
}
void JFW_Repair_Zone::Entered(GameObject * obj,GameObject * enter)
{
	int Player_Type = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,Player_Type) != 0)
	{
		return;
	}
	if (!Commands->Is_A_Star(enter))
	{
		Commands->Start_Timer(obj,this,1.0,Commands->Get_ID(enter));
	}
}
void JFW_Repair_Zone::Timer_Expired(GameObject * obj,int number)
{
	Vector3 pos1;
	Vector3 pos2;
	float distance;
	pos1 = Commands->Get_Position(obj);
	pos2 = Commands->Get_Position(Commands->Find_Object(number));
	distance = Commands->Get_Distance(pos1,pos2);
	if (distance <= Get_Float_Parameter("Repair_Distance"))
	{
		float Max_Health = Commands->Get_Max_Health(Commands->Find_Object(number));
		float Health = Commands->Get_Health(Commands->Find_Object(number));
		float Max_Shield_Strength = Commands->Get_Max_Shield_Strength(Commands->Find_Object(number));
		float Shield_Strength = Commands->Get_Shield_Strength(Commands->Find_Object(number));
		if (Health < Max_Health)
		{
			Commands->Set_Health(Commands->Find_Object(number), Health + Get_Float_Parameter("Repair_Health"));
		}
		if (Shield_Strength < Max_Shield_Strength)
		{
			Commands->Set_Shield_Strength(Commands->Find_Object(number), Shield_Strength + Get_Float_Parameter("Repair_Health"));
		}
		Commands->Start_Timer(obj, this, 1.0, number);
	}
}
void JFW_Repair_Zone_Aircraft_Only::Entered(GameObject * obj,GameObject * enter)
{
	int Player_Type = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,Player_Type) != 0)
	{
		return;
	}
	if ((stricmp(Commands->Get_Preset_Name(enter),Get_Parameter("Preset1")) == 0) || (stricmp(Commands->Get_Preset_Name(enter),Get_Parameter("Preset2")) == 0) || (stricmp(Commands->Get_Preset_Name(enter),Get_Parameter("Preset3")) == 0) || (stricmp(Commands->Get_Preset_Name(enter),Get_Parameter("Preset4")) == 0) || (stricmp(Commands->Get_Preset_Name(enter),Get_Parameter("Preset5")) == 0) || (stricmp(Commands->Get_Preset_Name(enter),Get_Parameter("Preset6")) == 0) || (stricmp(Commands->Get_Preset_Name(enter),Get_Parameter("Preset7")) == 0) || (stricmp(Commands->Get_Preset_Name(enter),Get_Parameter("Preset8")) == 0))
	{
		if (!Commands->Is_A_Star(enter))
		{
			Commands->Start_Timer(obj,this,1.0,Commands->Get_ID(enter));
		}
	}
}
void JFW_Repair_Zone_Aircraft_Only::Timer_Expired(GameObject * obj,int number)
{
	Vector3 pos1;
	Vector3 pos2;
	float distance;
	pos1 = Commands->Get_Position(obj);
	pos2 = Commands->Get_Position(Commands->Find_Object(number));
	distance = Commands->Get_Distance(pos1,pos2);
	if (distance <= Get_Float_Parameter("Repair_Distance"))
	{
		float Max_Health = Commands->Get_Max_Health(Commands->Find_Object(number));
		float Health = Commands->Get_Health(Commands->Find_Object(number));
		float Max_Shield_Strength = Commands->Get_Max_Shield_Strength(Commands->Find_Object(number));
		float Shield_Strength = Commands->Get_Shield_Strength(Commands->Find_Object(number));
		if (Health < Max_Health)
		{
			Commands->Set_Health(Commands->Find_Object(number), Health + Get_Float_Parameter("Repair_Health"));
		}
		if (Shield_Strength < Max_Shield_Strength)
		{
			Commands->Set_Shield_Strength(Commands->Find_Object(number), Shield_Strength + Get_Float_Parameter("Repair_Health"));
		}
		Commands->Start_Timer(obj, this, 1.0, number);
	}
}
void JFW_Repair_Zone_No_Aircraft::Entered(GameObject * obj,GameObject * enter)
{
	int Player_Type = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,Player_Type) != 0)
	{
		return;
	}
	if ((stricmp(Commands->Get_Preset_Name(enter),Get_Parameter("Preset1")) != 0) && (stricmp(Commands->Get_Preset_Name(enter),Get_Parameter("Preset2")) != 0) && (stricmp(Commands->Get_Preset_Name(enter),Get_Parameter("Preset3")) != 0) && (stricmp(Commands->Get_Preset_Name(enter),Get_Parameter("Preset4")) != 0) && (stricmp(Commands->Get_Preset_Name(enter),Get_Parameter("Preset5")) != 0) && (stricmp(Commands->Get_Preset_Name(enter),Get_Parameter("Preset6")) != 0) && (stricmp(Commands->Get_Preset_Name(enter),Get_Parameter("Preset7")) != 0) && (stricmp(Commands->Get_Preset_Name(enter),Get_Parameter("Preset8")) != 0))
	{
		if (!Commands->Is_A_Star(enter))
		{
			Commands->Start_Timer(obj,this,1.0,Commands->Get_ID(enter));
		}
	}
}
void JFW_Repair_Zone_No_Aircraft::Timer_Expired(GameObject * obj,int number)
{
	Vector3 pos1;
	Vector3 pos2;
	float distance;
	pos1 = Commands->Get_Position(obj);
	pos2 = Commands->Get_Position(Commands->Find_Object(number));
	distance = Commands->Get_Distance(pos1,pos2);
	if (distance <= Get_Float_Parameter("Repair_Distance"))
	{
		float Max_Health = Commands->Get_Max_Health(Commands->Find_Object(number));
		float Health = Commands->Get_Health(Commands->Find_Object(number));
		float Max_Shield_Strength = Commands->Get_Max_Shield_Strength(Commands->Find_Object(number));
		float Shield_Strength = Commands->Get_Shield_Strength(Commands->Find_Object(number));
		if (Health < Max_Health)
		{
			Commands->Set_Health(Commands->Find_Object(number), Health + Get_Float_Parameter("Repair_Health"));
		}
		if (Shield_Strength < Max_Shield_Strength)
		{
			Commands->Set_Shield_Strength(Commands->Find_Object(number), Shield_Strength + Get_Float_Parameter("Repair_Health"));
		}
		Commands->Start_Timer(obj, this, 1.0, number);
	}
}
void JFW_Building_Gun_Secondary::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Weapon_Secondary",params);
	}
}
void JFW_Building_Gun_Secondary::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_Secondary::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
			else
			{
				Commands->Send_Custom_Event(obj,object,x,1,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Weapon_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&primary);
}
void JFW_Building_Gun_Weapon_Secondary::Created(GameObject * obj)
{
	int visible;
	primary = true;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
}
void JFW_Building_Gun_Weapon_Secondary::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		Commands->Enable_Enemy_Seen(obj,param);
	}
}
void JFW_Building_Gun_Weapon_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	float minrange;
	float maxrange;
	float range;
	minrange = Get_Float_Parameter("Min_Range");
	maxrange = Get_Float_Parameter("Max_Range");
	Vector3 pos,pos2;
	pos = Commands->Get_Position(obj);
	pos2 = Commands->Get_Position(seen);
	range = Commands->Get_Distance(pos,pos2);
	pos.Z = 0;
	pos2.Z = 0;
	if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange))
	{
		ActionParamsStruct params;
		params.Set_Basic(this,100,1,-1);
		params.Set_Attack(seen,maxrange,0,primary);
		Commands->Action_Attack(obj,params);
		Commands->Start_Timer(obj,this,1.0,1);
		if (primary == true)
		{
			primary = false;
		}
		else
		{
			primary = true;
		}
	}
}
void JFW_Building_Gun_Weapon_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_Building_Gun_No_Aircraft_Secondary::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("Preset1"),Get_Parameter("Preset2"),Get_Parameter("Preset3"),Get_Parameter("Preset4"),Get_Parameter("Preset5"),Get_Parameter("Preset6"),Get_Parameter("Preset7"),Get_Parameter("Preset8"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Weapon_No_Aircraft_Secondary",params);
	}
}
void JFW_Building_Gun_No_Aircraft_Secondary::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_No_Aircraft_Secondary::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
			else
			{
				Commands->Send_Custom_Event(obj,object,x,1,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_No_Aircraft_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Weapon_No_Aircraft_Secondary::Created(GameObject * obj)
{
	int visible;
	primary = true;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
}
void JFW_Building_Gun_Weapon_No_Aircraft_Secondary::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		if (param == false)
		{
			Commands->Enable_Enemy_Seen(obj,false);
		}
		else
		{
			Commands->Enable_Enemy_Seen(obj,true);
		}
	}
}
void JFW_Building_Gun_Weapon_No_Aircraft_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	float minrange;
	float maxrange;
	float range;
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) != 0))
	{
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange))
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(seen,maxrange,0,primary);
			Commands->Action_Attack(obj,params);
			Commands->Start_Timer(obj,this,1.0,1);
			if (primary == true)
			{
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Building_Gun_Weapon_No_Aircraft_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_Building_Gun_Aircraft_Only_Secondary::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("Preset1"),Get_Parameter("Preset2"),Get_Parameter("Preset3"),Get_Parameter("Preset4"),Get_Parameter("Preset5"),Get_Parameter("Preset6"),Get_Parameter("Preset7"),Get_Parameter("Preset8"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Weapon_Aircraft_Only_Secondary",params);
	}
}
void JFW_Building_Gun_Aircraft_Only_Secondary::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_Aircraft_Only_Secondary::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
			else
			{
				Commands->Send_Custom_Event(obj,object,x,1,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Aircraft_Only_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Weapon_Aircraft_Only_Secondary::Created(GameObject * obj)
{
	int visible;
	primary = true;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
}
void JFW_Building_Gun_Weapon_Aircraft_Only_Secondary::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		if (param == false)
		{
			Commands->Enable_Enemy_Seen(obj,false);
		}
		else
		{
			Commands->Enable_Enemy_Seen(obj,true);
		}
	}
}
void JFW_Building_Gun_Weapon_Aircraft_Only_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	float minrange;
	float maxrange;
	float range;
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) == 0))
	{
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange))
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(seen,maxrange,0,primary);
			Commands->Action_Attack(obj,params);
			Commands->Start_Timer(obj,this,1.0,1);
			if (primary == true)
			{
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Building_Gun_Weapon_Aircraft_Only_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_Building_Gun_Weapon_No_Aircraft_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&primary);
}
void JFW_Building_Gun_Weapon_Aircraft_Only_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&primary);
}
void JFW_Building_Gun_Animated::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("EffectPreset"),Get_Parameter("EffectAnimation"),Get_Parameter("EffectTime"),Get_Parameter("EffectFrame"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Animated_Weapon",params);
	}
}
void JFW_Building_Gun_Animated::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_Animated::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Animated::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Animated_Weapon::Created(GameObject * obj)
{
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
	enemyseen = true;
	attackid = 0;
	GameObject *effect = Commands->Create_Object(Get_Parameter("EffectPreset"),Commands->Get_Position(obj));
	if (effect != 0)
	{
		effectid = Commands->Get_ID(effect);
		lastframe = false;
		Commands->Set_Animation(effect,Get_Parameter("EffectAnimation"),false,NULL,0,0,false);
	}
}
void JFW_Building_Gun_Animated_Weapon::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		Commands->Enable_Enemy_Seen(obj,false);
		enemyseen = false;
	}
}
void JFW_Building_Gun_Animated_Weapon::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	float minrange;
	float maxrange;
	float range;
	minrange = Get_Float_Parameter("Min_Range");
	maxrange = Get_Float_Parameter("Max_Range");
	Vector3 pos,pos2;
	pos = Commands->Get_Position(obj);
	pos2 = Commands->Get_Position(seen);
	range = Commands->Get_Distance(pos,pos2);
	pos.Z = 0;
	pos2.Z = 0;
	if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
	{
		enemyseen = false;
		Commands->Enable_Enemy_Seen(obj,false);
		attackid = Commands->Get_ID(seen);
		if (lastframe == false)
		{
			lastframe = true;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,0,Get_Float_Parameter("EffectFrame"),false);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("EffectTime"),1);
		}
	}
}
void JFW_Building_Gun_Animated_Weapon::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	enemyseen = true;
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Action_Reset(obj,100);
}
void JFW_Building_Gun_Animated_Weapon_No_Aircraft::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	enemyseen = true;
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Action_Reset(obj,100);
}
void JFW_Building_Gun_Animated_Weapon_Aircraft_Only::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	enemyseen = true;
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Action_Reset(obj,100);
}
void JFW_Building_Gun_Animated_Weapon_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	enemyseen = true;
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Action_Reset(obj,100);
}
void JFW_Building_Gun_Animated_Weapon_No_Aircraft_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	enemyseen = true;
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Action_Reset(obj,100);
}
void JFW_Building_Gun_Animated_Weapon_Aircraft_Only_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	enemyseen = true;
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Action_Reset(obj,100);
}
void JFW_Building_Gun_Animated_Weapon::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(Commands->Find_Object(attackid));
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if (lastframe == true)
		{
			lastframe = false;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,Get_Float_Parameter("EffectFrame"),0,false);
		}
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(Commands->Find_Object(attackid),maxrange,0,true);
			Commands->Action_Attack(obj,params);
		}
	}
}
void JFW_Building_Gun_Animated_No_Aircraft::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("Preset1"),Get_Parameter("Preset2"),Get_Parameter("Preset3"),Get_Parameter("Preset4"),Get_Parameter("Preset5"),Get_Parameter("Preset6"),Get_Parameter("Preset7"),Get_Parameter("Preset8"),Get_Parameter("EffectPreset"),Get_Parameter("EffectAnimation"),Get_Parameter("EffectTime"),Get_Parameter("EffectFrame"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Animated_Weapon_No_Aircraft",params);
	}
}
void JFW_Building_Gun_Animated_No_Aircraft::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_Animated_No_Aircraft::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Animated_No_Aircraft::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Animated_Weapon_No_Aircraft::Created(GameObject * obj)
{
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
	attackid = 0;
	GameObject *effect = Commands->Create_Object(Get_Parameter("EffectPreset"),Commands->Get_Position(obj));
	if (effect != 0)
	{
		effectid = Commands->Get_ID(effect);
		lastframe = false;
		Commands->Set_Animation(effect,Get_Parameter("EffectAnimation"),false,NULL,0,0,false);
	}
}
void JFW_Building_Gun_Animated_Weapon_No_Aircraft::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		Commands->Enable_Enemy_Seen(obj,false);
		enemyseen = false;
	}
}
void JFW_Building_Gun_Animated_Weapon_No_Aircraft::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) != 0))
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			enemyseen = false;
			Commands->Enable_Enemy_Seen(obj,false);
			attackid = Commands->Get_ID(seen);
			if (lastframe == false)
			{
				lastframe = true;
				Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,0,Get_Float_Parameter("EffectFrame"),false);
				Commands->Start_Timer(obj,this,Get_Float_Parameter("EffectTime"),1);
			}
		}
	}
}
void JFW_Building_Gun_Animated_Weapon_No_Aircraft::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(Commands->Find_Object(attackid));
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if (lastframe == true)
		{
			lastframe = false;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,Get_Float_Parameter("EffectFrame"),0,false);
		}
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(Commands->Find_Object(attackid),maxrange,0,true);
			Commands->Action_Attack(obj,params);
		}
	}
}
void JFW_Building_Gun_Animated_Aircraft_Only::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("Preset1"),Get_Parameter("Preset2"),Get_Parameter("Preset3"),Get_Parameter("Preset4"),Get_Parameter("Preset5"),Get_Parameter("Preset6"),Get_Parameter("Preset7"),Get_Parameter("Preset8"),Get_Parameter("EffectPreset"),Get_Parameter("EffectAnimation"),Get_Parameter("EffectTime"),Get_Parameter("EffectFrame"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Animated_Weapon_Aircraft_Only",params);
	}
}
void JFW_Building_Gun_Animated_Aircraft_Only::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_Animated_Aircraft_Only::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Animated_Aircraft_Only::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Animated_Weapon_Aircraft_Only::Created(GameObject * obj)
{
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
	enemyseen = true;
	attackid = 0;
	GameObject *effect = Commands->Create_Object(Get_Parameter("EffectPreset"),Commands->Get_Position(obj));
	if (effect != 0)
	{
		effectid = Commands->Get_ID(effect);
		lastframe = false;
		Commands->Set_Animation(effect,Get_Parameter("EffectAnimation"),false,NULL,0,0,false);
	}
}
void JFW_Building_Gun_Animated_Weapon_Aircraft_Only::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		Commands->Enable_Enemy_Seen(obj,false);
		enemyseen = false;
	}
}
void JFW_Building_Gun_Animated_Weapon_Aircraft_Only::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) == 0))
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			enemyseen = false;
			Commands->Enable_Enemy_Seen(obj,false);
			attackid = Commands->Get_ID(seen);
			if (lastframe == false)
			{
				lastframe = true;
				Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,0,Get_Float_Parameter("EffectFrame"),false);
				Commands->Start_Timer(obj,this,Get_Float_Parameter("EffectTime"),1);
			}
		}
	}
}
void JFW_Building_Gun_Animated_Weapon_Aircraft_Only::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(Commands->Find_Object(attackid));
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if (lastframe == true)
		{
			lastframe = false;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,Get_Float_Parameter("EffectFrame"),0,false);
		}
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(Commands->Find_Object(attackid),maxrange,0,true);
			Commands->Action_Attack(obj,params);
		}
	}
}
void JFW_Building_Gun_Animated_Secondary::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("EffectPreset"),Get_Parameter("EffectAnimation"),Get_Parameter("EffectTime"),Get_Parameter("EffectFrame"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Animated_Weapon_Secondary",params);
	}
}
void JFW_Building_Gun_Animated_Secondary::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_Animated_Secondary::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Animated_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Animated_Weapon_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&primary);
	Auto_Save_Variable(2,4,&effectid);
	Auto_Save_Variable(3,4,&attackid);
	Auto_Save_Variable(4,1,&enemyseen);
	Auto_Save_Variable(5,1,&lastframe);
}
void JFW_Building_Gun_Animated_Weapon::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&effectid);
	Auto_Save_Variable(2,4,&attackid);
	Auto_Save_Variable(3,1,&enemyseen);
	Auto_Save_Variable(4,1,&lastframe);
}
void JFW_Building_Gun_Animated_Weapon_Secondary::Created(GameObject * obj)
{
	primary = true;
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
	enemyseen = true;
	attackid = 0;
	GameObject *effect = Commands->Create_Object(Get_Parameter("EffectPreset"),Commands->Get_Position(obj));
	if (effect != 0)
	{
		effectid = Commands->Get_ID(effect);
		lastframe = false;
		Commands->Set_Animation(effect,Get_Parameter("EffectAnimation"),false,NULL,0,0,false);
	}
}
void JFW_Building_Gun_Animated_Weapon_Secondary::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		Commands->Enable_Enemy_Seen(obj,false);
		enemyseen = false;
	}
}
void JFW_Building_Gun_Animated_Weapon_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	float minrange;
	float maxrange;
	float range;
	minrange = Get_Float_Parameter("Min_Range");
	maxrange = Get_Float_Parameter("Max_Range");
	Vector3 pos,pos2;
	pos = Commands->Get_Position(obj);
	pos2 = Commands->Get_Position(seen);
	range = Commands->Get_Distance(pos,pos2);
	pos.Z = 0;
	pos2.Z = 0;
	if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
	{
		enemyseen = false;
		Commands->Enable_Enemy_Seen(obj,false);
		attackid = Commands->Get_ID(seen);
		if (lastframe == false)
		{
			lastframe = true;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,0,Get_Float_Parameter("EffectFrame"),false);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("EffectTime"),1);
		}
	}
}
void JFW_Building_Gun_Animated_Weapon_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(Commands->Find_Object(attackid));
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if (lastframe == true)
		{
			lastframe = false;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,Get_Float_Parameter("EffectFrame"),0,false);
		}
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(Commands->Find_Object(attackid),maxrange,0,primary);
			Commands->Action_Attack(obj,params);
			if (primary == true)
			{
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Building_Gun_Animated_No_Aircraft_Secondary::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("Preset1"),Get_Parameter("Preset2"),Get_Parameter("Preset3"),Get_Parameter("Preset4"),Get_Parameter("Preset5"),Get_Parameter("Preset6"),Get_Parameter("Preset7"),Get_Parameter("Preset8"),Get_Parameter("EffectPreset"),Get_Parameter("EffectAnimation"),Get_Parameter("EffectTime"),Get_Parameter("EffectFrame"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Animated_Weapon_No_Aircraft_Secondary",params);
	}
}
void JFW_Building_Gun_Animated_No_Aircraft_Secondary::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_Animated_No_Aircraft_Secondary::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Animated_No_Aircraft_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Animated_Weapon_No_Aircraft_Secondary::Created(GameObject * obj)
{
	primary = true;
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
	enemyseen = true;
	attackid = 0;
	GameObject *effect = Commands->Create_Object(Get_Parameter("EffectPreset"),Commands->Get_Position(obj));
	if (effect != 0)
	{
		effectid = Commands->Get_ID(effect);
		lastframe = false;
		Commands->Set_Animation(effect,Get_Parameter("EffectAnimation"),false,NULL,0,0,false);
	}
}
void JFW_Building_Gun_Animated_Weapon_No_Aircraft_Secondary::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		Commands->Enable_Enemy_Seen(obj,false);
		enemyseen = false;
	}
}
void JFW_Building_Gun_Animated_Weapon_No_Aircraft_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) != 0))
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			enemyseen = false;
			Commands->Enable_Enemy_Seen(obj,false);
			attackid = Commands->Get_ID(seen);
			if (lastframe == false)
			{
				lastframe = true;
				Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,0,Get_Float_Parameter("EffectFrame"),false);
				Commands->Start_Timer(obj,this,Get_Float_Parameter("EffectTime"),1);
			}
		}
	}
}
void JFW_Building_Gun_Animated_Weapon_No_Aircraft_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(Commands->Find_Object(attackid));
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if (lastframe == true)
		{
			lastframe = false;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,Get_Float_Parameter("EffectFrame"),0,false);
		}
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(Commands->Find_Object(attackid),maxrange,0,primary);
			Commands->Action_Attack(obj,params);
			if (primary == true)
			{
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Building_Gun_Animated_Aircraft_Only_Secondary::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("Preset1"),Get_Parameter("Preset2"),Get_Parameter("Preset3"),Get_Parameter("Preset4"),Get_Parameter("Preset5"),Get_Parameter("Preset6"),Get_Parameter("Preset7"),Get_Parameter("Preset8"),Get_Parameter("EffectPreset"),Get_Parameter("EffectAnimation"),Get_Parameter("EffectTime"),Get_Parameter("EffectFrame"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Animated_Weapon_Aircraft_Only_Secondary",params);
	}
}
void JFW_Building_Gun_Animated_Aircraft_Only_Secondary::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_Animated_Aircraft_Only_Secondary::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Animated_Aircraft_Only_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Animated_Weapon_Aircraft_Only_Secondary::Created(GameObject * obj)
{
	primary = true;
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
	enemyseen = true;
	attackid = 0;
	GameObject *effect = Commands->Create_Object(Get_Parameter("EffectPreset"),Commands->Get_Position(obj));
	if (effect != 0)
	{
		effectid = Commands->Get_ID(effect);
		lastframe = false;
		Commands->Set_Animation(effect,Get_Parameter("EffectAnimation"),false,NULL,0,0,false);
	}
}
void JFW_Building_Gun_Animated_Weapon_Aircraft_Only_Secondary::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		Commands->Enable_Enemy_Seen(obj,false);
		enemyseen = false;
	}
}
void JFW_Building_Gun_Animated_Weapon_Aircraft_Only_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) == 0))
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			enemyseen = false;
			Commands->Enable_Enemy_Seen(obj,false);
			attackid = Commands->Get_ID(seen);
			if (lastframe == false)
			{
				lastframe = true;
				Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,0,Get_Float_Parameter("EffectFrame"),false);
				Commands->Start_Timer(obj,this,Get_Float_Parameter("EffectTime"),1);
			}
		}
	}
}
void JFW_Building_Gun_Animated_Weapon_Aircraft_Only_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(Commands->Find_Object(attackid));
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if (lastframe == true)
		{
			lastframe = false;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,Get_Float_Parameter("EffectFrame"),0,false);
		}
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(Commands->Find_Object(attackid),maxrange,0,primary);
			Commands->Action_Attack(obj,params);
			if (primary == true)
			{
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Building_Gun_Animated_Weapon_No_Aircraft::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&effectid);
	Auto_Save_Variable(2,4,&attackid);
	Auto_Save_Variable(3,1,&enemyseen);
	Auto_Save_Variable(4,1,&lastframe);
}
void JFW_Building_Gun_Animated_Weapon_Aircraft_Only::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&effectid);
	Auto_Save_Variable(2,4,&attackid);
	Auto_Save_Variable(3,1,&enemyseen);
	Auto_Save_Variable(4,1,&lastframe);
}
void JFW_Building_Gun_Animated_Weapon_No_Aircraft_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&primary);
	Auto_Save_Variable(2,4,&effectid);
	Auto_Save_Variable(3,4,&attackid);
	Auto_Save_Variable(4,1,&enemyseen);
	Auto_Save_Variable(5,1,&lastframe);
}
void JFW_Building_Gun_Animated_Weapon_Aircraft_Only_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&primary);
	Auto_Save_Variable(2,4,&effectid);
	Auto_Save_Variable(3,4,&attackid);
	Auto_Save_Variable(4,1,&enemyseen);
	Auto_Save_Variable(5,1,&lastframe);
}
ScriptRegistrant<JFW_Bounce_Zone_Entry> JFW_Bounce_Zone_Entry_Registrant("JFW_Bounce_Zone_Entry","Player_Type:int,Amount:float");
ScriptRegistrant<JFW_Grant_Key_Zone_Entry> JFW_Grant_Key_Zone_Entry_Registrant("JFW_Grant_Key_Zone_Entry","Player_Type:int,Key:int");
ScriptRegistrant<JFW_Custom_Play_Cinematic> JFW_Custom_Play_Cinematic_Registrant("JFW_Custom_Play_Cinematic","Message:int,Script_Name:string,Location:Vector3,Facing:float");
ScriptRegistrant<JFW_Debug_Text_File> JFW_Debug_Text_File_Registrant("JFW_Debug_Text_File","Log_File:string,Description:string");
ScriptRegistrant<JFW_Timer_Custom> JFW_Timer_Custom_Registrant("JFW_Timer_Custom","Time:float,TimerNum:int,Repeat:int,ID:int,Message:int,Param:int");
ScriptRegistrant<JFW_Blow_Up_On_Death> JFW_Blow_Up_On_Death_Registrant("JFW_Blow_Up_On_Death","Explosion:string");
ScriptRegistrant<JFW_Zone_Send_Custom_Enable> JFW_Zone_Send_Custom_Enable_Registrant("JFW_Zone_Send_Custom_Enable","ID:int,EnterMessage:int,EnterParam:int,ExitMessage:int,ExitParam:int,Player_Type:int,Enable_Message:int,Disable_Message:int");
ScriptRegistrant<JFW_Zone_Send_Custom_Preset> JFW_Zone_Send_Custom_Preset_Registrant("JFW_Zone_Send_Custom_Preset","ID:int,EnterMessage:int,EnterParam:int,ExitMessage:int,ExitParam:int,Player_Type:int,Preset_Name:string");
ScriptRegistrant<JFW_Zone_Send_Custom_Enable_Enter> JFW_Zone_Send_Custom_Enable_Enter_Registrant("JFW_Zone_Send_Custom_Enable_Enter","EnterMessage:int,EnterParam:int,ExitMessage:int,ExitParam:int,Player_Type:int,Enable_Message:int,Disable_Message:int");
ScriptRegistrant<JFW_Zone_Send_Custom_Preset_Enter> JFW_Zone_Send_Custom_Preset_Enter_Registrant("JFW_Zone_Send_Custom_Preset_Enter","EnterMessage:int,EnterParam:int,ExitMessage:int,ExitParam:int,Player_Type:int,Preset_Name:string");
ScriptRegistrant<JFW_2D_Sound_Timer_Random> JFW_2D_Sound_Timer_Random_Registrant("JFW_2D_Sound_Timer_Random","Time_Min:float,Time_Max:float,TimerNum:int,Repeat:int,Sound:string");
ScriptRegistrant<JFW_3D_Sound_Timer_Random> JFW_3D_Sound_Timer_Random_Registrant("JFW_3D_Sound_Timer_Random","Time_Min:float,Time_Max:float,TimerNum:int,Repeat:int,Sound:string,Position:Vector3");
ScriptRegistrant<JFW_2D_Sound_Timer_Health> JFW_2D_Sound_Timer_Health_Registrant("JFW_2D_Sound_Timer_Health","Time:float,TimerNum:int,Repeat:int,Sound:string,Min_Health:float,Max_Health:float");
ScriptRegistrant<JFW_Aircraft_Fuel> JFW_Aircraft_Fuel_Registrant("JFW_Aircraft_Fuel","Time:float,TimerNum:int,Explosion:string,Refuel_Message:int");
ScriptRegistrant<JFW_Power_Off> JFW_Power_Off_Registrant("JFW_Power_Off","Message_Off:int,Message_On:int");
ScriptRegistrant<JFW_Assault_Powerplant_Controller> JFW_Assault_Powerplant_Controller_Registrant("JFW_Assault_Powerplant_Controller","Time:float,TimerNum:int,Player_Type:int,Power_Off:int,Power_On:int,Building1:int,Building2:int,Building3:int,Building4:int,Building5:int,Building6:int,Building7:int,Building8:int,Building9:int,Building10:int,Building11:int,Building12:int,Building13:int,Building14:int,Building15:int");
ScriptRegistrant<JFW_Nod_Obelisk_CnC> JFW_Nod_Obelisk_CnC_Registrant("JFW_Nod_Obelisk_CnC","Controller_ID=0:int");
ScriptRegistrant<JFW_Obelisk_Weapon_CnC> JFW_Obelisk_Weapon_CnC_Registrant("JFW_Obelisk_Weapon_CnC","");
ScriptRegistrant<JFW_Advanced_Guard_Tower> JFW_Advanced_Guard_Tower_Registrant("JFW_Advanced_Guard_Tower","");
ScriptRegistrant<JFW_Advanced_Guard_Tower_Missile> JFW_Advanced_Guard_Tower_Missile_Registrant("JFW_Advanced_Guard_Tower_Missile","");
ScriptRegistrant<JFW_Advanced_Guard_Tower_Gun> JFW_Advanced_Guard_Tower_Gun_Registrant("JFW_Advanced_Guard_Tower_Gun","");
ScriptRegistrant<JFW_Building_Gun> JFW_Building_Gun_Registrant("JFW_Building_Gun","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float");
ScriptRegistrant<JFW_Building_Gun_Weapon> JFW_Building_Gun_Weapon_Registrant("JFW_Building_Gun_Weapon","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float");
ScriptRegistrant<JFW_Building_Gun_No_Aircraft> JFW_Building_Gun_No_Aircraft_Registrant("JFW_Building_Gun_No_Aircraft","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string");
ScriptRegistrant<JFW_Building_Gun_Aircraft_Only> JFW_Building_Gun_Aircraft_Only_Registrant("JFW_Building_Gun_Aircraft_Only","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string");
ScriptRegistrant<JFW_Building_Gun_Weapon_No_Aircraft> JFW_Building_Gun_Weapon_No_Aircraft_Registrant("JFW_Building_Gun_Weapon_No_Aircraft","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string");
ScriptRegistrant<JFW_Building_Gun_Weapon_Aircraft_Only> JFW_Building_Gun_Weapon_Aircraft_Only_Registrant("JFW_Building_Gun_Weapon_Aircraft_Only","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string");
ScriptRegistrant<JFW_Guard_Duty_Helper> JFW_Guard_Duty_Helper_Registrant("JFW_Guard_Duty_Helper","ID:int,Helper_Msg:int");
ScriptRegistrant<JFW_Guard_Duty> JFW_Guard_Duty_Registrant("JFW_Guard_Duty","Helper_Obj:string,Helper_Bone:string,Range:float,Dummy_Object:int,Helper_Msg:int,Waypathid:int,Attack_Time:float,Wait_Time:float");
ScriptRegistrant<JFW_Hunt_Attack> JFW_Hunt_Attack_Registrant("JFW_Hunt_Attack","Attack_Range:float");
ScriptRegistrant<JFW_Hunt_Blow_Up> JFW_Hunt_Blow_Up_Registrant("JFW_Hunt_Blow_Up","Speed:float,Distance:float,Explosion:string");
ScriptRegistrant<JFW_Follow_Waypath> JFW_Follow_Waypath_Registrant("JFW_Follow_Waypath","Waypathid:int,Speed:float");
ScriptRegistrant<JFW_Give_Money> JFW_Give_Money_Registrant("JFW_Give_Money","Message:int,Entire_Team:int,Amount:int");
ScriptRegistrant<JFW_2D_Sound_Custom> JFW_2D_Sound_Custom_Registrant("JFW_2D_Sound_Custom","Message:int,Preset:string");
ScriptRegistrant<JFW_Random_Custom> JFW_Random_Custom_Registrant("JFW_Random_Custom","Message:int,ID:int,TimerNum:int,Time_Min:float,Time_Max:float,Repeat:int");
ScriptRegistrant<JFW_Resource_Collector> JFW_Resource_Collector_Registrant("JFW_Resource_Collector","Collected_Mesasge:int,Refinery_Message:int,Cash_Limit:int,Cash_Type:int,Entire_Team:int");
ScriptRegistrant<JFW_Resource_Refinery> JFW_Resource_Refinery_Registrant("JFW_Resource_Refinery","Refinery_Message:int");
ScriptRegistrant<JFW_Resource_Field> JFW_Resource_Field_Registrant("JFW_Resource_Field","Cash:int,Time:float,TimerNum:int,Collected_Preset:string,Collected_Preset_Distance:float,Collected_Message:int,Nod_Preset:string,GDI_Preset:string,StartHarvest:int,StopHarvest:int");
ScriptRegistrant<JFW_Custom_Damage_Object> JFW_Custom_Damage_Object_Registrant("JFW_Custom_Damage_Object","ID:int,Message:int,Damage:Float");
ScriptRegistrant<JFW_Blow_Up_On_Custom> JFW_Blow_Up_On_Custom_Registrant("JFW_Blow_Up_On_Custom","Explosion:string,Message:int");
ScriptRegistrant<JFW_Blow_Up_Obj_On_Custom> JFW_Blow_Obj_Up_On_Custom_Registrant("JFW_Blow_Obj_Up_On_Custom","Explosion:string,Message:int");
ScriptRegistrant<JFW_Delay_Custom> JFW_Delay_Custom_Registrant("JFW_Delay_Custom","Message:int,Delay:Float,ID:int");
ScriptRegistrant<JFW_Startup_Custom> JFW_Startup_Custom_Registrant("JFW_Startup_Custom","Message:int,ID:int");
ScriptRegistrant<JFW_Clear_Weapons> JFW_Clear_Weapons_Registrant("JFW_Clear_Weapons","");
ScriptRegistrant<JFW_Send_Custom_Zone_Enter> JFW_Send_Custom_Zone_Enter_Registrant("JFW_Send_Custom_Zone_Enter","EnterMessage:int,EnterParam:int,ExitMessage:int,ExitParam:int,Team_ID:int");
ScriptRegistrant<JFW_Gate_Zone> JFW_Gate_Zone_Registrant("JFW_Gate_Zone","Player_Type:int,Time:Float,TimerNum:int,ID:int,Animation:string");
ScriptRegistrant<JFW_Repair_Zone> JFW_Repair_Zone_Registrant("JFW_Repair_Zone","Player_Type:int,Repair_Distance:float,Repair_Health:float");
ScriptRegistrant<JFW_Repair_Zone_Aircraft_Only> JFW_Repair_Zone_Aircraft_Only_Registrant("JFW_Repair_Zone_Aircraft_Only","Player_Type:int,Repair_Distance:float,Repair_Health:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string");
ScriptRegistrant<JFW_Repair_Zone_No_Aircraft> JFW_Repair_Zone_No_Aircraft_Registrant("JFW_Repair_Zone_No_Aircraft","Player_Type:int,Repair_Distance:float,Repair_Health:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string ");
ScriptRegistrant<JFW_Building_Gun_Secondary> JFW_Building_Gun_Secondary_Registrant("JFW_Building_Gun_Secondary","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float");
ScriptRegistrant<JFW_Building_Gun_Weapon_Secondary> JFW_Building_Gun_Weapon_Secondary_Registrant("JFW_Building_Gun_Weapon_Secondary","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float");
ScriptRegistrant<JFW_Building_Gun_No_Aircraft_Secondary> JFW_Building_Gun_No_Aircraft_Secondary_Registrant("JFW_Building_Gun_No_Aircraft_Secondary","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string");
ScriptRegistrant<JFW_Building_Gun_Aircraft_Only_Secondary> JFW_Building_Gun_Aircraft_Only_Secondary_Registrant("JFW_Building_Gun_Aircraft_Only_Secondary","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string");
ScriptRegistrant<JFW_Building_Gun_Weapon_No_Aircraft_Secondary> JFW_Building_Gun_Weapon_No_Aircraft_Secondary_Registrant("JFW_Building_Gun_Weapon_No_Aircraft_Secondary","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string");
ScriptRegistrant<JFW_Building_Gun_Weapon_Aircraft_Only_Secondary> JFW_Building_Gun_Weapon_Aircraft_Only_Secondary_Registrant("JFW_Building_Gun_Weapon_Aircraft_Only_Secondary","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string");
ScriptRegistrant<JFW_Building_Gun_Animated> JFW_Building_Gun_Animated_Registrant("JFW_Building_Gun_Animated","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float");
ScriptRegistrant<JFW_Building_Gun_Animated_Weapon> JFW_Building_Gun_Animated_Weapon_Registrant("JFW_Building_Gun_Animated_Weapon","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float");
ScriptRegistrant<JFW_Building_Gun_Animated_No_Aircraft> JFW_Building_Gun_Animated_No_Aircraft_Registrant("JFW_Building_Gun_Animated_No_Aircraft","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float");
ScriptRegistrant<JFW_Building_Gun_Animated_Aircraft_Only> JFW_Building_Gun_Animated_Aircraft_Only_Registrant("JFW_Building_Gun_Animated_Aircraft_Only","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float");
ScriptRegistrant<JFW_Building_Gun_Animated_Weapon_No_Aircraft> JFW_Building_Gun_Animated_Weapon_No_Aircraft_Registrant("JFW_Building_Gun_Animated_Weapon_No_Aircraft","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float");
ScriptRegistrant<JFW_Building_Gun_Animated_Weapon_Aircraft_Only> JFW_Building_Gun_Animated_Weapon_Aircraft_Only_Registrant("JFW_Building_Gun_Animated_Weapon_Aircraft_Only","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float");
ScriptRegistrant<JFW_Building_Gun_Animated_Secondary> JFW_Building_Gun_Animated_Secondary_Registrant("JFW_Building_Gun_Animated_Secondary","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float");
ScriptRegistrant<JFW_Building_Gun_Animated_Weapon_Secondary> JFW_Building_Gun_Animated_Weapon_Secondary_Registrant("JFW_Building_Gun_Animated_Weapon_Secondary","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float");
ScriptRegistrant<JFW_Building_Gun_Animated_No_Aircraft_Secondary> JFW_Building_Gun_Animated_No_Aircraft_Secondary_Registrant("JFW_Building_Gun_Animated_No_Aircraft_Secondary","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float");
ScriptRegistrant<JFW_Building_Gun_Animated_Aircraft_Only_Secondary> JFW_Building_Gun_Animated_Aircraft_Only_Secondary_Registrant("JFW_Building_Gun_Animated_Aircraft_Only_Secondary","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float");
ScriptRegistrant<JFW_Building_Gun_Animated_Weapon_No_Aircraft_Secondary> JFW_Building_Gun_Animated_Weapon_No_Aircraft_Secondary_Registrant("JFW_Building_Gun_Animated_Weapon_No_Aircraft_Secondary","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float");
ScriptRegistrant<JFW_Building_Gun_Animated_Weapon_Aircraft_Only_Secondary> JFW_Building_Gun_Animated_Weapon_Aircraft_Only_Secondary_Registrant("JFW_Building_Gun_Animated_Weapon_Aircraft_Only_Secondary","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float");
